<?php

/**
 * Configuration file for MihanVideo Importer
 */

return [
    // Sitemap settings
    'sitemap_url' => 'https://mihanvideo.com/sitemap-last.xml',
    
    // Processing limits
    'max_videos' => 2000,
    'min_title_length' => 40,
    'max_execution_time' => 900,
    'memory_limit' => '512M',
    
    // CDN settings
    'cdn_base_url' => 'https://cdn.arvandvideo.ir/s2_pic/',
    
    // Server replacements for CDN
    'server_replacements' => [
        '//s1' => '//ss1-',
        '//s2' => '//ss2-',
        '//s3' => '//ss3-',
        '//s4' => '//ss4-',
        '//s5' => '//ss5-',
        '//s6' => '//ss6-',
        '//s7' => '//ss7-',
        '//s8' => '//ss8-'
    ],
    
    // WordPress settings
    'post_type' => 'post',
    'post_status' => 'publish',
    'post_author' => 1,
    
    // Custom fields
    'custom_fields' => [
        'video_url' => 's2_url',
        'thumbnail' => 's2_pic',
        'source_url' => 's2_source'
    ],
    
    // Security settings
    'allowed_domains' => ['mihanvideo.com'],
    'max_input_length' => 500,
    
    // Logging
    'log_errors' => true,
    'display_errors' => true
];

?>
