<?php

/**
 * Test script for MihanVideo Importer
 * This script tests the basic functionality without WordPress dependencies
 */

echo "<h2>MihanVideo Importer Test</h2>\n";

// Test 1: Check if files exist
echo "<h3>1. File Existence Check</h3>\n";
$files = ['s2.php', 's2_pic.php', 's2_url.php', 'config.php', 'admin.php'];
foreach ($files as $file) {
    if (file_exists($file)) {
        echo "✓ {$file} exists<br>\n";
    } else {
        echo "✗ {$file} missing<br>\n";
    }
}

// Test 2: Check PHP syntax
echo "<h3>2. PHP Syntax Check</h3>\n";
$phpFiles = ['s2.php', 's2_pic.php', 's2_url.php', 'config.php'];
foreach ($phpFiles as $file) {
    $output = [];
    $returnCode = 0;
    exec("php -l {$file} 2>&1", $output, $returnCode);
    
    if ($returnCode === 0) {
        echo "✓ {$file} syntax OK<br>\n";
    } else {
        echo "✗ {$file} syntax error: " . implode(' ', $output) . "<br>\n";
    }
}

// Test 3: Test URL processing functions
echo "<h3>3. URL Processing Test</h3>\n";

// Test s2_pic.php functionality
$testPicId = 'ss5-testimage123.jpg';
$expectedPicUrl = 'https://s5.mihanvideo.com/video_thumbs/testimage123.jpg';

// Simulate the URL processing logic
$newpic = $testPicId;
$newpic = str_replace('ss5-', 's5.mihanvideo.com/video_thumbs/', $newpic);
$newpic = str_replace('--', '/', $newpic);
$finalUrl = "https://" . $newpic;

if ($finalUrl === $expectedPicUrl) {
    echo "✓ s2_pic.php URL processing works correctly<br>\n";
} else {
    echo "✗ s2_pic.php URL processing failed. Expected: {$expectedPicUrl}, Got: {$finalUrl}<br>\n";
}

// Test s2_url.php functionality
$testVideoId = 'ss5-testvideo123/testfile.mp4';
$expectedVideoUrl = 'https://s5.mihanvideo.com/user_contents/videos/testvideo123/testfile.mp4';

$newpic = $testVideoId;
$newpic = str_replace('ss5-', 's5.mihanvideo.com/user_contents/videos/', $newpic);
$newpic = str_replace('--', '/', $newpic);
$finalUrl = "https://" . $newpic;

if ($finalUrl === $expectedVideoUrl) {
    echo "✓ s2_url.php URL processing works correctly<br>\n";
} else {
    echo "✗ s2_url.php URL processing failed. Expected: {$expectedVideoUrl}, Got: {$finalUrl}<br>\n";
}

// Test 4: Test configuration loading
echo "<h3>4. Configuration Test</h3>\n";
if (file_exists('config.php')) {
    $config = require_once 'config.php';
    if (is_array($config) && isset($config['max_videos'])) {
        echo "✓ Configuration loaded successfully<br>\n";
        echo "Max videos: " . $config['max_videos'] . "<br>\n";
    } else {
        echo "✗ Configuration format invalid<br>\n";
    }
} else {
    echo "✗ Configuration file not found<br>\n";
}

// Test 5: Test input validation
echo "<h3>5. Input Validation Test</h3>\n";

// Test valid input
$validInput = 'ss5-valid123/test.jpg';
if (preg_match('/^[a-zA-Z0-9\-\/]+$/', $validInput)) {
    echo "✓ Valid input accepted<br>\n";
} else {
    echo "✗ Valid input rejected<br>\n";
}

// Test invalid input
$invalidInput = 'ss5-invalid<script>alert("xss")</script>.jpg';
if (!preg_match('/^[a-zA-Z0-9\-\/]+$/', $invalidInput)) {
    echo "✓ Invalid input rejected<br>\n";
} else {
    echo "✗ Invalid input accepted<br>\n";
}

echo "<h3>Test Complete</h3>\n";
echo "<p>All basic functionality tests completed. Check results above.</p>\n";

?>
